<?php

namespace App\Http\Controllers\TherapistCommunitys;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Post;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityPosts\CreateRequest;
use App\Http\Resources\Web\PostsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistCommunityPostsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('therapist_community');
        // $this->middleware('permission:therapist_community_posts.index');
        // $this->middleware('permission:therapist_community_posts.create',['only' => ['store']]);
        // $this->middleware('permission:therapist_community_posts.update',['only' => ['update']]);
        // $this->middleware('permission:therapist_community_posts.delete',['only' => ['destroy']]);
        // $this->middleware('permission:therapist_community_posts.export',['only' => ['export']]);
        // $this->middleware('permission:therapist_community_posts.import',['only' => ['import']])
        // $this->middleware('permission:therapist_community_posts.update|therapist_community_posts.is_active',['only' => ['updateStatus']]);
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($req != null) {
            $therapist_community_posts =  $therapist_community->therapist_community_posts()->withAll();
            if ($req->trash && $req->trash == 'with') {
                $therapist_community_posts =  $therapist_community_posts->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_community_posts =  $therapist_community_posts->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_community_posts = $therapist_community_posts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_community_posts = $therapist_community_posts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort && $req->sort['field'] != null && $req->sort['type'] != null) {
                $therapist_community_posts = $therapist_community_posts->OrderBy($req->sort['field'], $req->sort['type']);
            } else {
                $therapist_community_posts = $therapist_community_posts->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_community_posts = $therapist_community_posts->get();
                return $therapist_community_posts;
            }
            $totalTherapistCommunityPosts = $therapist_community_posts->count();
            $therapist_community_posts = $therapist_community_posts->paginate($req->perPage);
            $therapist_community_posts = PostsResource::collection($therapist_community_posts)->response()->getData(true);

            return $therapist_community_posts;
        }
        $therapist_community_posts = PostsResource::collection($therapist_community->therapist_community_posts()->withAll()->orderBy('id', 'desc')->paginate(10))->response()->getData(true);
        return $therapist_community_posts;
    }

    /********* FETCH ALL TherapistCommunityPosts ***********/
    public function index()
    {
        $therapist_community_posts =  $this->getter();
        $response = generateResponse($therapist_community_posts, count($therapist_community_posts['data']) > 0 ? true : false, 'TherapistCommunityPosts Fetched Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* FILTER TherapistCommunityPosts FOR Search ***********/
    public function filter(Request $request)
    {
        $therapist_community_posts = $this->getter($request);
        $response = generateResponse($therapist_community_posts, count($therapist_community_posts['data']) > 0 ? true : false, 'Filter TherapistCommunityPosts Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* ADD NEW TherapistCommunityPost ***********/
    public function store(CreateRequest $request)
    {
        $therapist_community = auth()->user()->therapist_community;
        try {
            DB::beginTransaction();
            $request->merge(['created_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            $data['image'] = uploadCroppedFile($request, 'image', 'therapist_community_posts');
            $therapist_community_post = $therapist_community->therapist_community_posts()->create($data);
            $therapist_community_post->slug = Str::slug($therapist_community_post->name . ' ' . $therapist_community_post->id, '-');
            $therapist_community_post->save();
            $therapist_community_post = $therapist_community->therapist_community_posts()->withAll()->find($therapist_community_post->id);
            $therapist_community_post = new PostsResource($therapist_community_post);
            $therapist_community_post->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
        }
        return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show($therapist_community_post)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_post->therapist_community_id != $therapist_community->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_post = $therapist_community->therapist_community_posts()->withAll()->find($therapist_community_post);
        if ($therapist_community_post) {
            $therapist_community_post = new PostsResource($therapist_community_post);
            $response = generateResponse($therapist_community_post, true, 'TherapistCommunityPost Fetched Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistCommunityPost Not FOund', null, 'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityPost ***********/
    public function update(CreateRequest $request, Post $therapist_community_post)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_post->therapist_community_id != $therapist_community->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        try {
            DB::beginTransaction();
            $request->merge(['last_updated_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request, 'image', 'therapist_community_posts', $therapist_community_post->image);
            } else {
                $data['image'] = $therapist_community_post->image;
            }
            $therapist_community_post->update($data);
            $therapist_community_post = $therapist_community_post->find($therapist_community_post->id);
            $slug = Str::slug($therapist_community_post['name'] . ' ' . $therapist_community_post->id, '-');
            $therapist_community_post->update(
                [
                    'slug' => $slug
                ]
            );
            $therapist_community_post->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
        }
        return redirect()->back();
    }

    /********* UPDATE TherapistCommunityPost Status***********/
    public function updateStatus(Request $request, Post $therapist_community_post)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_post->therapist_community_id != $therapist_community->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_post->update([
            'is_active' => $therapist_community_post->is_active == 1 ? 0 : 1
        ]);
        $response = generateResponse(null, true, 'TherapistCommunityPost Status Updated Successfully', null, 'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityPost ***********/
    public function destroy(Request $request, Post $therapist_community_post)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_post->therapist_community_id != $therapist_community->id) {
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
            return redirect()->back();
        }
        if ($therapist_community_post->trashed()) {
            request()->session()->flash('alert', ['message' => 'Already in Trash', 'type' => 'error']);
        } else {
            $therapist_community_post->delete();
        }
        return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityPost ***********/
    public function destroyPermanently(Request $request, $therapist_community_post)
    {
        $therapist_community = auth()->user()->therapist_community;
        $therapist_community_post = $therapist_community->therapist_community_posts()->withTrashed()->find($therapist_community_post);
        if ($therapist_community_post) {
            if ($therapist_community_post->therapist_community_id != $therapist_community->id) {
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
            if ($therapist_community_post->trashed()) {
                $therapist_community_post->forceDelete();
                $response = generateResponse(null, true, 'TherapistCommunityPost Deleted Successfully', null, 'object');
            } else {
                $response = generateResponse(null, false, 'TherapistCommunityPost is not in trash to delete permanently', null, 'object');
            }
        } else {
            $response = generateResponse(null, false, 'TherapistCommunityPost not found', null, 'object');
        }
        return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityPost ***********/
    public function restore(Request $request, $therapist_community_post)
    {
        $therapist_community = auth()->user()->therapist_community;
        $therapist_community_post = $therapist_community->therapist_community_posts()->withTrashed()->find($therapist_community_post);
        if ($therapist_community_post->trashed()) {
            $therapist_community_post->restore();
            $response = generateResponse(null, true, 'TherapistCommunityPost Restored Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistCommunityPost is not trashed', null, 'object');
        }
        return response()->json($response, 200);
    }
}
